function [M, N, nbdeleted, Detect_immimm] = delete_virtual(M, pourc, T)
% It deletes tracks with 20% of virtual detection or with 3 successive
% virtual detection

% Output:
% - M : new tracks
% - N : number of original tracks
% - nbdeleted : number of deleted tracks

% Tracks' numbers must be increasing

ind =find(isnan(M(:,1))==0);
N=numel(ind);
M(ind,1)=[0:N-1];
Detect_immimm =M(ind,1);


for i=1:N-1

    ind1=find(M(:,1)==i-1);
    ind2=find(M(:,1)==i);

    
    VIRT = M(ind1+2:ind2-2,6);
    
    % percentage of virtual
    
    perc = numel(find(VIRT==1))/numel(VIRT);
    
    % successive virtual detection
    
    k=2;
    todelete=0;
    if numel(VIRT)>3
    while todelete==0 & k < numel(VIRT)-1
        if M(ind1+1+k,6) == 1 &  M(ind1+k,6) == 1 & M(ind1+k+2,6) == 1
           todelete=1;
        end
        k=k+1;
    end
    end

    % delete track
    
    if perc >pourc |  todelete==1 | numel(VIRT)<T+1
        M(ind1:ind2-1,:)=[];
        Detect_immimm(i)=-1;
    end
    
    
end

% re-order tracks
ind =find(isnan(M(:,1))==0);
Nafter=numel(ind);
M(ind,1)=[0:Nafter-1];

indimmimm=find(Detect_immimm==-1);
Detect_immimm(indimmimm)=[];

nbdeleted= N-Nafter;

end

